<?php
/**
 * ZanCms
 * ============================================================================
 * 版权所有 2020-2035 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.zancms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\home\model;

use think\Db;
use think\Model;

/**
 * 产品图片
 */
class ProductImg extends Model
{
    //初始化
    protected function initialize()
    {
        // 需要调用`Model`的`initialize`方法
        parent::initialize();
    }

    /**
     * 获取第一条数据所对应的语言
     * @return [type] [description]
     */
    public function getFirstLang()
    {
        $info = Db::name('images_upload')->field('lang')->order('img_id asc')->find();

        return !empty($info['lang']) ? $info['lang'] : get_home_lang();
    }
    
    /**
     * 获取指定产品的所有图片
     * @author 小虎哥 by 2018-4-3
     */
    public function getProImg($aids = [], $lang = '')
    {
        $where = [
            'lang' => !empty($lang) ? $lang : get_home_lang(),
        ];
        !empty($aids) && $where['aid'] = ['IN', $aids];
        $result = Db::name('ProductImg')
            ->where($where)
            ->order('sort_order asc')
            ->select();
        !empty($result) && $result = group_same_key($result, 'aid');

        return $result;
    }
}